/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.resource.loader.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3266;
import net.minecraft.class_3270;
import org.jetbrains.annotations.Nullable;

public abstract class GroupResourcePack
implements class_3262 {
    protected final class_3264 type;
    protected final List<? extends class_3262> packs;
    protected final Map<String, List<class_3262>> namespacedPacks = new Object2ObjectOpenHashMap();

    public GroupResourcePack(class_3264 type, List<? extends class_3262> packs) {
        this.type = type;
        this.packs = packs;
        this.packs.forEach(pack -> pack.method_14406(this.type).forEach(namespace -> this.namespacedPacks.computeIfAbsent((String)namespace, value -> new ArrayList()).add(pack)));
    }

    public List<? extends class_3262> getPacks() {
        return Collections.unmodifiableList(this.packs);
    }

    public List<? extends class_3262> getPacks(String namespace) {
        return Collections.unmodifiableList(this.namespacedPacks.get(namespace));
    }

    public Stream<? extends class_3262> streamPacks() {
        return this.packs.stream().mapMulti((pack, consumer) -> {
            if (pack instanceof GroupResourcePack) {
                GroupResourcePack grouped = (GroupResourcePack)pack;
                grouped.streamPacks().forEach((Consumer<? extends class_3262>)consumer);
            } else {
                consumer.accept(pack);
            }
        });
    }

    public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
        List<class_3262> packs = this.namespacedPacks.get(id.method_12836());
        if (packs != null) {
            for (int i = packs.size() - 1; i >= 0; --i) {
                class_3262 pack = packs.get(i);
                if (!pack.method_14411(type, id)) continue;
                return pack.method_14405(type, id);
            }
        }
        throw new class_3266(null, String.format("%s/%s/%s", type.method_14413(), id.method_12836(), id.method_12832()));
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        List<class_3262> packs = this.namespacedPacks.get(namespace);
        if (packs == null) {
            return Collections.emptyList();
        }
        HashSet<class_2960> resources = new HashSet<class_2960>();
        for (int i = packs.size() - 1; i >= 0; --i) {
            class_3262 pack = packs.get(i);
            Collection modResources = pack.method_14408(type, namespace, prefix, maxDepth, pathFilter);
            resources.addAll(modResources);
        }
        return resources;
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        List<class_3262> packs = this.namespacedPacks.get(id.method_12836());
        if (packs == null) {
            return false;
        }
        for (int i = packs.size() - 1; i >= 0; --i) {
            class_3262 pack = packs.get(i);
            if (!pack.method_14411(type, id)) continue;
            return true;
        }
        return false;
    }

    public Set<String> method_14406(class_3264 type) {
        return this.namespacedPacks.keySet();
    }

    public String getFullName() {
        return this.method_14409() + " (" + this.packs.stream().map(class_3262::method_14409).collect(Collectors.joining(", ")) + ")";
    }

    public void close() {
        this.packs.forEach(class_3262::close);
    }

    public static class Wrapped
    extends GroupResourcePack {
        private final class_3262 basePack;

        public Wrapped(class_3264 type, class_3262 basePack, List<class_3262> packs, boolean basePriority) {
            super(type, Wrapped.addToPacksIfNeeded(basePack, packs, basePriority));
            this.basePack = basePack;
        }

        private static List<class_3262> addToPacksIfNeeded(class_3262 basePack, List<class_3262> packs, boolean basePriority) {
            if (!packs.contains(basePack)) {
                if (basePriority) {
                    packs.add(basePack);
                } else {
                    packs.add(0, basePack);
                }
            }
            return packs;
        }

        @Nullable
        public InputStream method_14410(String fileName) throws IOException {
            return this.basePack.method_14410(fileName);
        }

        @Nullable
        public <T> T method_14407(class_3270<T> metaReader) throws IOException {
            return (T)this.basePack.method_14407(metaReader);
        }

        public String method_14409() {
            return this.basePack.method_14409();
        }

        @Override
        public String getFullName() {
            return this.method_14409() + " (" + this.packs.stream().filter(pack -> pack != this.basePack).map(class_3262::method_14409).collect(Collectors.joining(", ")) + ")";
        }
    }
}

